<?php
// Include the dotenv library to load environment variables
require_once __DIR__ . '/../vendor/autoload.php';  // Adjust path if necessary

// Load the .env file
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

// Database configurations (you can add more if needed)
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_NAME', getenv('DB_NAME') ?: 'your_database');
define('DB_USER', getenv('DB_USER') ?: 'your_username');
define('DB_PASS', getenv('DB_PASS') ?: 'your_password');

// Thinkific API configurations
define('THINKIFIC_API_KEY', getenv('THINKIFIC_API_KEY'));
define('THINKIFIC_SUBDOMAIN', getenv('THINKIFIC_SUBDOMAIN'));

// Email configurations
define('EMAIL_USER', getenv('EMAIL_USER'));
define('EMAIL_PASS', getenv('EMAIL_PASS'));

// Other environment variables can be added here
