<?php
// Include necessary files (e.g., header, database connection, etc.)
include('includes/db.php');

// Start session if needed
session_start();

// Check if the user is redirected here after OTP verification
// (You can also check if a session variable is set after successful verification)
if (!isset($_GET['email']) || empty($_GET['email'])) {
    header("Location: index.php");
    exit();
}

$email = filter_var($_GET['email'], FILTER_SANITIZE_EMAIL);

// You can add additional checks here, e.g., check if the user exists, or if they're logged in
// For example, you could create a user session here or redirect them to the dashboard

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Verification Successful</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 100px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            border: 1px solid #ddd;
        }
        h2 {
            text-align: center;
            color: #4CAF50;
        }
        p {
            font-size: 16px;
            color: #333;
            text-align: center;
        }
        .button {
            display: block;
            width: 100%;
            padding: 12px;
            font-size: 16px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 4px;
            text-align: center;
            cursor: pointer;
            margin-top: 20px;
        }
        .button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>OTP Verification Successful!</h2>
        <p>Congratulations! Your email address has been successfully verified.</p>
        <p>You can now proceed with the next steps:</p>
        <ul>
            <li><a href="login.php" class="button">Log In to Your Account</a></li>
            <li><a href="register_user.php" class="button">Complete Your Registration</a></li>
            <li><a href="dashboard.php" class="button">Go to Your Dashboard</a></li>
        </ul>
        <p>If you need any help, feel free to <a href="contact.php">contact us</a>.</p>
    </div>
</body>
</html>
