<?php
// Include necessary files
include('includes/db.php');

// Start session if needed to track user data
session_start();

// Check if the email and OTP are provided via GET or POST
if (isset($_GET['email'])) {
    $email = filter_var($_GET['email'], FILTER_SANITIZE_EMAIL);
} elseif (isset($_POST['email']) && isset($_POST['otp'])) {
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $otp = filter_var($_POST['otp'], FILTER_SANITIZE_NUMBER_INT);
} else {
    die("Invalid request.");
}

// Check if the form is submitted
if (isset($_POST['submit'])) {
    // Validate OTP
    if (empty($otp) || strlen($otp) !== 6) {
        $error_message = "Invalid OTP. Please enter a 6-digit OTP.";
    } else {
        // Check if the OTP exists in the database
        $pdo = getDbConnection();
        $stmt = $pdo->prepare("SELECT * FROM otps WHERE email = :email AND otp = :otp AND expiry > NOW()");
        $stmt->execute(['email' => $email, 'otp' => $otp]);
        $otpRecord = $stmt->fetch();

        // If OTP is valid
        if ($otpRecord) {
            // Mark the OTP as used or delete it to prevent reuse
            $deleteStmt = $pdo->prepare("DELETE FROM otps WHERE email = :email AND otp = :otp");
            $deleteStmt->execute(['email' => $email, 'otp' => $otp]);

            // Proceed with the next step (e.g., registration or login)
            echo "OTP successfully verified! You can now proceed.";
            // Example: Redirect to registration page
            // header("Location: register_user.php");
            // exit();
        } else {
            // OTP is invalid or expired
            $error_message = "Invalid OTP or OTP has expired. Please try again.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify OTP</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 500px;
            margin: 100px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            border: 1px solid #ddd;
        }
        h2 {
            text-align: center;
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            font-size: 14px;
            color: #333;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        button {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #0056b3;
        }
        .error {
            color: red;
            font-size: 14px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Enter OTP to Verify</h2>
        
        <!-- Display error message if any -->
        <?php if (isset($error_message)): ?>
            <p class="error"><?php echo $error_message; ?></p>
        <?php endif; ?>

        <!-- Form to input OTP -->
        <form action="verify.php" method="POST">
            <!-- Hidden email field, passed via GET or POST -->
            <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>" />
            
            <div class="form-group">
                <label for="otp">Enter OTP</label>
                <input type="text" name="otp" id="otp" required />
            </div>
            
            <button type="submit" name="submit">Verify OTP</button>
        </form>
    </div>
</body>
</html>
