<?php
// Sample email template for OTP verification

// Variables that will be replaced dynamically
$otp = $data['otp']; // OTP code (passed from send_otp.php)
$expiry_time = $data['expiry_time']; // Expiry time (passed from send_otp.php)
$website_name = "Your Website Name"; // Replace with your website name
$verify_url = $data['verify_url']; // Verification URL (to redirect the user to OTP verification page)

// Email body content
$email_content = "
<!DOCTYPE html>
<html lang='en'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>OTP Verification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
            border-bottom: 1px solid #ddd;
        }
        .header h2 {
            margin: 0;
            color: #333;
        }
        .body {
            padding: 20px;
        }
        .otp-code {
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 14px;
            color: #888;
        }
        .footer a {
            color: #007BFF;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class='email-container'>
        <div class='header'>
            <h2>OTP Verification for {$website_name}</h2>
        </div>
        <div class='body'>
            <p>Dear User,</p>
            <p>Thank you for registering with {$website_name}. To complete your registration process, please verify your email by entering the OTP below:</p>
            <p class='otp-code'>{$otp}</p>
            <p>This OTP will expire in {$expiry_time}.</p>
            <p><a href='{$verify_url}' target='_blank'>Click here to verify your email</a></p>
            <p>If you did not request this, please ignore this email.</p>
        </div>
        <div class='footer'>
            <p>Best regards,</p>
            <p>The {$website_name} Team</p>
            <p><a href='https://yourwebsite.com'>Visit our website</a></p>
        </div>
    </div>
</body>
</html>
";

// Output the email content (you can send this as the body of the email)
echo $email_content;
?>
